/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.potions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.potion.AffectEntity;
import noppes.npcs.api.event.potion.EndEffect;
import noppes.npcs.api.event.potion.IsReadyEvent;
import noppes.npcs.api.event.potion.PerformEffect;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.util.ValueUtil;

public class CustomPotion
extends Potion
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected ResourceLocation resource;
    protected ItemStack cureItem = ItemStack.field_190927_a;
    protected final Map<IAttribute, AttributeModifier> field_111188_I = new HashMap<IAttribute, AttributeModifier>();

    public CustomPotion(NBTTagCompound nbtPotion) {
        super(nbtPotion.func_74767_n("IsBadEffect"), nbtPotion.func_74762_e("LiquidColor"));
        this.nbtData = nbtPotion;
        String name = nbtPotion.func_74779_i("RegistryName").toLowerCase();
        this.setRegistryName(new ResourceLocation("customnpcs", "custom_potion_" + name));
        this.func_76390_b("effect." + name);
        if (nbtPotion.func_74767_n("IsBeneficial")) {
            this.func_188413_j();
        }
        if (nbtPotion.func_150297_b("CureItem", 10)) {
            this.cureItem = new ItemStack(nbtPotion.func_74775_l("CureItem"));
        }
        if (nbtPotion.func_150297_b("Modifiers", 10)) {
            this.field_111188_I.clear();
            for (int i = 0; i < nbtPotion.func_150295_c("Modifiers", 10).func_74745_c(); ++i) {
                NBTTagCompound potionModifier = nbtPotion.func_150295_c("Modifiers", 10).func_150305_b(i);
                try {
                    UUID uuid;
                    double d = potionModifier.func_74769_h("AttributeDefValue");
                    double m = potionModifier.func_74769_h("AttributeMinValue");
                    double n = potionModifier.func_74769_h("AttributeMaxValue");
                    try {
                        uuid = UUID.fromString(potionModifier.func_74779_i("UUID"));
                    }
                    catch (Exception e) {
                        uuid = UUID.randomUUID();
                    }
                    this.field_111188_I.put((IAttribute)new RangedAttribute(null, potionModifier.func_74779_i("AttributeName"), ValueUtil.correctDouble(d, m, n), ValueUtil.min(m, n), ValueUtil.max(m, n)), new AttributeModifier(uuid, this.func_76393_a(), potionModifier.func_74769_h("Amount"), potionModifier.func_74762_e("Operation")));
                    continue;
                }
                catch (Exception e) {
                    LogWriter.error("Error create or added attribute modifier #" + i + " to custom potion: \"" + this.getCustomName() + "\"", e);
                }
            }
        }
        this.resource = new ResourceLocation("customnpcs", "textures/potions/" + name + ".png");
    }

    public void func_180793_a(@Nullable Entity source, @Nullable Entity indirectSource, @Nonnull EntityLivingBase entityLivingBaseIn, int amplifier, double health) {
        AffectEntity event = new AffectEntity(this, source, indirectSource, entityLivingBaseIn, amplifier, health);
        EventHooks.onCustomPotionAffectEntity(event);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.potionScripts, "customPotionAffectEntity", (Event)event);
    }

    public void func_111185_a(@Nonnull EntityLivingBase entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.field_111188_I.entrySet()) {
            IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(entry.getKey());
            AttributeModifier attributemodifier = entry.getValue();
            iattributeinstance.func_111124_b(attributemodifier);
            iattributeinstance.func_111121_a(new AttributeModifier(attributemodifier.func_111167_a(), this.func_76393_a() + " " + amplifier, this.func_111183_a(amplifier, attributemodifier), attributemodifier.func_111169_c()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Map<IAttribute, AttributeModifier> func_111186_k() {
        return this.field_111188_I;
    }

    @Nonnull
    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.cureItem.func_190926_b()) {
            ret.add(this.cureItem);
        } else {
            ret.add(new ItemStack(Items.field_151117_aB));
        }
        return ret;
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public boolean func_76400_d() {
        return false;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        boolean isReady = true;
        if (this.nbtData.func_150297_b("Duration", 3)) {
            boolean bl = isReady = duration % this.nbtData.func_74762_e("Duration") == 0;
        }
        if (isReady || duration % 10 == 0) {
            IsReadyEvent event = new IsReadyEvent(this, isReady, duration, amplifier);
            EventHooks.onCustomPotionIsReady(event);
            EventHooks.onEvent((IScriptHandler)ScriptController.Instance.potionScripts, "customPotionIsReady", (Event)event);
            isReady = event.ready;
        }
        return isReady;
    }

    public void func_76394_a(@Nonnull EntityLivingBase entityLivingBaseIn, int amplifier) {
        PerformEffect event = new PerformEffect(this, entityLivingBaseIn, amplifier);
        EventHooks.onCustomPotionPerformEffect(event);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.potionScripts, "customPotionPerformEffect", (Event)event);
    }

    @Nonnull
    public Potion func_111184_a(@Nonnull IAttribute attribute, @Nonnull String uniqueId, double amount, int operation) {
        AttributeModifier attributemodifier = new AttributeModifier(UUID.fromString(uniqueId), this.func_76393_a(), amount, operation);
        this.field_111188_I.put(attribute, attributemodifier);
        return this;
    }

    public void func_111187_a(@Nonnull EntityLivingBase entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.field_111188_I.entrySet()) {
            IAttributeInstance iattributeinstance = attributeMapIn.func_111151_a(entry.getKey());
            iattributeinstance.func_111124_b(entry.getValue());
        }
        EndEffect event = new EndEffect(this, entityLivingBaseIn, amplifier);
        EventHooks.onCustomPotionEndEffect(event);
        EventHooks.onEvent((IScriptHandler)ScriptController.Instance.potionScripts, "customPotionEndEffect", (Event)event);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(@Nonnull PotionEffect effect, @Nonnull Gui gui, int x, int y, float z, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resource);
        Gui.func_146110_a((int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(@Nonnull PotionEffect effect, @Nonnull Gui gui, int x, int y, float z) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resource);
        Gui.func_146110_a((int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (float)18.0f, (float)18.0f);
    }

    @Override
    public int getType() {
        return 7;
    }
}

